/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.parser.core;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.ast.CodeBlock;
import icyllis.flexmark.ast.IndentedCodeBlock;
import icyllis.flexmark.ast.Paragraph;
import icyllis.flexmark.parser.Parser;
import icyllis.flexmark.parser.block.AbstractBlockParser;
import icyllis.flexmark.parser.block.AbstractBlockParserFactory;
import icyllis.flexmark.parser.block.BlockContinue;
import icyllis.flexmark.parser.block.BlockParserFactory;
import icyllis.flexmark.parser.block.BlockStart;
import icyllis.flexmark.parser.block.CustomBlockParserFactory;
import icyllis.flexmark.parser.block.MatchedBlockParser;
import icyllis.flexmark.parser.block.ParserState;
import icyllis.flexmark.parser.core.BlockQuoteParser;
import icyllis.flexmark.parser.core.FencedCodeBlockParser;
import icyllis.flexmark.parser.core.HeadingParser;
import icyllis.flexmark.parser.core.HtmlBlockParser;
import icyllis.flexmark.parser.core.ListBlockParser;
import icyllis.flexmark.parser.core.ThematicBreakParser;
import icyllis.flexmark.util.ast.Block;
import icyllis.flexmark.util.ast.BlockContent;
import icyllis.flexmark.util.collection.iteration.Reverse;
import icyllis.flexmark.util.data.DataHolder;
import icyllis.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class IndentedCodeBlockParser
extends AbstractBlockParser {
    private final IndentedCodeBlock block = new IndentedCodeBlock();
    private BlockContent content = new BlockContent();
    private final boolean trimTrailingBlankLines;
    private final boolean codeContentBlock;

    public IndentedCodeBlockParser(DataHolder options) {
        this.trimTrailingBlankLines = Parser.INDENTED_CODE_NO_TRAILING_BLANK_LINES.get(options);
        this.codeContentBlock = Parser.FENCED_CODE_CONTENT_BLOCK.get(options);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (state.getIndent() >= state.getParsing().CODE_BLOCK_INDENT) {
            return BlockContinue.atColumn(state.getColumn() + state.getParsing().CODE_BLOCK_INDENT);
        }
        if (state.isBlank()) {
            return BlockContinue.atIndex(state.getNextNonSpaceIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    @Override
    public void closeBlock(ParserState state) {
        if (this.trimTrailingBlankLines) {
            BasedSequence line;
            int trailingBlankLines = 0;
            List<BasedSequence> lines = this.content.getLines();
            Iterator iterator = new Reverse<BasedSequence>(lines).iterator();
            while (iterator.hasNext() && (line = (BasedSequence)iterator.next()).isBlank()) {
                ++trailingBlankLines;
            }
            if (trailingBlankLines > 0) {
                this.block.setContent(lines.subList(0, lines.size() - trailingBlankLines));
            } else {
                this.block.setContent(this.content);
            }
        } else {
            this.block.setContent(this.content);
        }
        if (this.codeContentBlock) {
            CodeBlock codeBlock = new CodeBlock(this.block.getChars(), this.block.getContentLines());
            this.block.appendChild(codeBlock);
        }
        this.content = null;
    }

    public static class BlockFactory
    extends AbstractBlockParserFactory {
        private BlockFactory(DataHolder options) {
            super(options);
        }

        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (state.getIndent() >= state.getParsing().CODE_BLOCK_INDENT && !state.isBlank() && !(state.getActiveBlockParser().getBlock() instanceof Paragraph)) {
                return BlockStart.of(new IndentedCodeBlockParser(state.getProperties())).atColumn(state.getColumn() + state.getParsing().CODE_BLOCK_INDENT);
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        @Override
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return new HashSet(Arrays.asList(BlockQuoteParser.Factory.class, HeadingParser.Factory.class, FencedCodeBlockParser.Factory.class, HtmlBlockParser.Factory.class, ThematicBreakParser.Factory.class, ListBlockParser.Factory.class));
        }

        @Override
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return Collections.emptySet();
        }

        @Override
        public boolean affectsGlobalScope() {
            return false;
        }

        @Override
        @NotNull
        public BlockParserFactory apply(@NotNull DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

